Sets i /1*2/
     l /GJM1,GJM2,ALT/;

alias(i,j)

Parameter
    x1(j)
    /  1  10
       2   6  /
    y1(i)
    /  1   4
       2  12  /;

Scalar G1,F;
   G1=sum(j, x1(j));

   F=G1/5;

   G1=G1/F;

   x1(j)=x1(j)/F;
   y1(i)=y1(i)/F;

Parameter zero(i,j);
   zero('1','1')=0;
   zero('1','2')=0;
   zero('2','1')=0;
   zero('2','2')=0;

Variables
   lambda(i)
   mi(j)
   ni(i,j)
   M       entropy;

Equations
     obj_gjm1    define objective function - golan & judge & miller
     obj_gjm2    define objective function - golan & judge & miller
     obj_alt     define objective function - alternative;

obj_gjm1..    M =e= sum(i, lambda(i)*y1(i))
                 + sum(j, log(sum(i, exp(-lambda(i)*x1(j)-ni(i,j)*zero(i,j)))));

obj_gjm2..    M =e= sum(j, mi(j)*x1(j))
                 + sum(i, log(sum(j, exp(-mi(j)*y1(i)-ni(i,j)*zero(i,j)))));

obj_alt..    M =e= sum(i, lambda(i)*y1(i))
                 + sum(j, mi(j)*x1(j))
                 + log(sum((i,j), exp(-(lambda(i)+mi(j))*G1-ni(i,j)*zero(i,j))));

Model VP_GJM1 /obj_gjm1/ ;
Model VP_GJM2 /obj_gjm2/ ;
Model VP_ALT /obj_alt/ ;

Parameter omega1(j),omega2,A1_HAT(i,j,l),B1_HAT(i,j,l);

option NLP=CONOPT2;

mi.l(j)=0;
lambda.l(i)=0;

solve VP_GJM1 using NLP minimizing M;

   omega1(j)=sum(i, exp(-lambda.l(i)*x1(j)-ni.l(i,j)*zero(i,j)));
   A1_HAT(i,j,'GJM1')=exp(-lambda.l(i)*x1(j)-ni.l(i,j)*zero(i,j))/omega1(j);
   B1_HAT(i,j,'GJM1')=A1_HAT(i,j,'GJM1')*x1(j)*F;

mi.l(j)=0;
lambda.l(i)=0;

solve VP_GJM2 using NLP minimizing M;

   omega1(i)=sum(j, exp(-mi.l(j)*y1(i)-ni.l(i,j)*zero(i,j)));
   A1_HAT(i,j,'GJM2')=exp(-mi.l(j)*y1(i)-ni.l(i,j)*zero(i,j))/omega1(i);
   B1_HAT(i,j,'GJM2')=A1_HAT(i,j,'GJM2')*y1(i)*F;

mi.l(j)=0;
lambda.l(i)=0;

solve VP_ALT using NLP minimizing M;

   omega2=sum((i,j), exp(-(lambda.l(i)+mi.l(j))*G1-ni.l(i,j)*zero(i,j)));
   A1_HAT(i,j,'ALT')=G1/x1(j)*exp(-(lambda.l(i)+mi.l(j))*G1-ni.l(i,j)*zero(i,j))/omega2;
   B1_HAT(i,j,'ALT')=A1_HAT(i,j,'ALT')*x1(j)*F;

option decimals=5

display B1_HAT;